//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify certificate status
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_CRL     "cmp_crl.crl"
#define CMP_RA_CERT "cmp_ra.cer"
//#define CMP_RA_CERT "rev.cer"
//------------------------------------------------------------------------------
unsigned char *CRL;
unsigned char Cert[8196];
//------------------------------------------------------------------------------
// :
// 1.      
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hCRL;
 DWORD sz,szc;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  
 if (getFileLen(CMP_CRL,   &sz)) {printf("getFileLen error\r\n"); return 1;}
 CRL=(unsigned char*) calloc(sz+1,sizeof(unsigned char));
 if (readFile  (CMP_CRL,CRL,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   
 if (getFileLen(CMP_RA_CERT,    &szc)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_RA_CERT,Cert,szc)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //    
 if (!CPImportKey(hProv,CRL,sz,0,0,&hCRL)) {
   printf("CPImportKey(CRL) Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 if (!CPVerifySignature(hProv,0,Cert,szc,hCRL,NULL,CRYPT_OBJECT_REV)) {
   printf("CPVerifySignature Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 CPDestroyKey(hProv,hCRL);
 free(CRL);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
